/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.adventurez.init.ItemInit;
import net.adventurez.item.armor.GildedNetheriteArmor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={HumanoidArmorLayer.class})
public abstract class ArmorFeatureRendererMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    @Shadow
    @Final
    @Mutable
    private A f_117072_;
    private boolean gildedNetheriteArmorOnFire = false;
    private static final ResourceLocation GILDED_NETHERITE_ARMOR = new ResourceLocation("minecraft:textures/models/armor/gilded_netherite_layer_1_overlay.png");
    private static final ResourceLocation GILDED_NETHERITE_HELMET = new ResourceLocation("minecraft:textures/models/armor/gilded_netherite_layer_1_overlay_helmet.png");

    public ArmorFeatureRendererMixin(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void renderMixin(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo info) {
        ItemStack golemChestplate = livingEntity.m_6844_(EquipmentSlot.CHEST);
        if (golemChestplate.m_150930_(ItemInit.GILDED_NETHERITE_CHESTPLATE) && GildedNetheriteArmor.isStoneGolemArmorActive(golemChestplate)) {
            this.gildedNetheriteArmorOnFire = true;
        } else if (this.gildedNetheriteArmorOnFire) {
            this.gildedNetheriteArmorOnFire = false;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;renderArmor(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/EquipmentSlot;ILnet/minecraft/client/render/entity/model/BipedEntityModel;)V", ordinal=3)})
    private void renderGlowingArmorOneMixin(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo info) {
        if (this.gildedNetheriteArmorOnFire) {
            VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumerProvider, (RenderType)RenderType.m_110431_((ResourceLocation)GILDED_NETHERITE_ARMOR), (boolean)false, (boolean)false);
            this.f_117072_.m_7695_(matrixStack, vertexConsumer, 220, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;renderArmor(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/EquipmentSlot;ILnet/minecraft/client/render/entity/model/BipedEntityModel;)V", ordinal=2)})
    private void renderGlowingArmorTwoMixin(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo info) {
        if (this.gildedNetheriteArmorOnFire) {
            VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumerProvider, (RenderType)RenderType.m_110431_((ResourceLocation)GILDED_NETHERITE_ARMOR), (boolean)false, (boolean)false);
            this.f_117072_.m_7695_(matrixStack, vertexConsumer, 220, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderGlowingHelmetMixin(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo info) {
        if (this.gildedNetheriteArmorOnFire) {
            VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumerProvider, (RenderType)RenderType.m_110431_((ResourceLocation)GILDED_NETHERITE_HELMET), (boolean)false, (boolean)false);
            this.f_117072_.m_7695_(matrixStack, vertexConsumer, 220, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

